"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.INTERNALS = void 0;
var _nextUrl = require("../next-url");
var _utils = require("../../utils");
var _utils1 = require("../utils");
var _cookie = _interopRequireDefault(require("next/dist/compiled/cookie"));
var _uaParserJs = _interopRequireDefault(require("next/dist/compiled/ua-parser-js"));
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const INTERNALS = Symbol('internal request');
exports.INTERNALS = INTERNALS;
class NextRequest extends Request {
    constructor(input, init = {
    }){
        var ref, ref1, ref2;
        super(input, init);
        const cookieParser = ()=>{
            const value = this.headers.get('cookie');
            return value ? _cookie.default.parse(value) : {
            };
        };
        this[INTERNALS] = {
            cookieParser,
            geo: init.geo || {
            },
            ip: init.ip,
            page: init.page,
            url: new _nextUrl.NextURL(typeof input === 'string' ? input : input.url, {
                basePath: (ref = init.nextConfig) === null || ref === void 0 ? void 0 : ref.basePath,
                headers: (0, _utils1).toNodeHeaders(this.headers),
                i18n: (ref1 = init.nextConfig) === null || ref1 === void 0 ? void 0 : ref1.i18n,
                trailingSlash: (ref2 = init.nextConfig) === null || ref2 === void 0 ? void 0 : ref2.trailingSlash
            })
        };
    }
    get cookies() {
        return this[INTERNALS].cookieParser();
    }
    get geo() {
        return this[INTERNALS].geo;
    }
    get ip() {
        return this[INTERNALS].ip;
    }
    get preflight() {
        return this.headers.get('x-middleware-preflight');
    }
    get nextUrl() {
        return this[INTERNALS].url;
    }
    get page() {
        var ref, ref1;
        return {
            name: (ref = this[INTERNALS].page) === null || ref === void 0 ? void 0 : ref.name,
            params: (ref1 = this[INTERNALS].page) === null || ref1 === void 0 ? void 0 : ref1.params
        };
    }
    get ua() {
        if (typeof this[INTERNALS].ua !== 'undefined') {
            return this[INTERNALS].ua || undefined;
        }
        const uaString = this.headers.get('user-agent');
        if (!uaString) {
            this[INTERNALS].ua = null;
            return this[INTERNALS].ua || undefined;
        }
        this[INTERNALS].ua = {
            ...(0, _uaParserJs).default(uaString),
            isBot: (0, _utils).isBot(uaString)
        };
        return this[INTERNALS].ua;
    }
    get url() {
        return this[INTERNALS].url.toString();
    }
}
exports.NextRequest = NextRequest;

//# sourceMappingURL=request.js.map