"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getRouteMatcher = getRouteMatcher;
var _utils = require("../../utils");
function getRouteMatcher(routeRegex) {
    const { re , groups  } = routeRegex;
    return (pathname)=>{
        const routeMatch = re.exec(pathname);
        if (!routeMatch) {
            return false;
        }
        const decode = (param)=>{
            try {
                return decodeURIComponent(param);
            } catch (_) {
                throw new _utils.DecodeError('failed to decode param');
            }
        };
        const params = {
        };
        Object.keys(groups).forEach((slugName)=>{
            const g = groups[slugName];
            const m = routeMatch[g.pos];
            if (m !== undefined) {
                params[slugName] = ~m.indexOf('/') ? m.split('/').map((entry)=>decode(entry)
                ) : g.repeat ? [
                    decode(m)
                ] : decode(m);
            }
        });
        return params;
    };
}

//# sourceMappingURL=route-matcher.js.map