"use strict";

exports.__esModule = true;
exports["default"] = JSXStyle;

var _react = _interopRequireDefault(require("react"));

var _stylesheetRegistry = require("./stylesheet-registry");

var _hash = require("./lib/hash");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// Opt-into the new `useInsertionEffect` API in React 18, fallback to `useLayoutEffect`.
// https://github.com/reactwg/react-18/discussions/110
var useInsertionEffect = _react["default"].useInsertionEffect || _react["default"].useLayoutEffect;
var defaultRegistry = typeof window !== 'undefined' ? (0, _stylesheetRegistry.createStyleRegistry)() : undefined;

function JSXStyle(props) {
  var registry = defaultRegistry ? defaultRegistry : (0, _stylesheetRegistry.useStyleRegistry)(); // If `registry` does not exist, we do nothing here.

  if (!registry) {
    return null;
  }

  if (typeof window === 'undefined') {
    registry.add(props);
    return null;
  }

  useInsertionEffect(function () {
    registry.add(props);
    return function () {
      registry.remove(props);
    }; // props.children can be string[], will be striped since id is identical
  }, [props.id, String(props.dynamic)]);
  return null;
}

JSXStyle.dynamic = function (info) {
  return info.map(function (tagInfo) {
    var baseId = tagInfo[0];
    var props = tagInfo[1];
    return (0, _hash.computeId)(baseId, props);
  }).join(' ');
};