import React from "react";
import Link from "next/link";

function Navbar() {
  return (
    <nav className="flex items-center justify-between flex-wrap bg-blue-800 p-4 w-full">
      <div className="items-center text-white">
        <span className="font-semibold text-2xl"> WallerudTech Golf</span>
      </div>

      <div className="flex-grow flex items-center w-auto">
        <div className="text-sm flex-grow"></div>
        <div className="">
          <a
            href="/admin"
            className="flex text-sm px-4 py-2 items-center justify-center leading-none border rounded text-white border-white hover:border-transparent hover:text-blue-800 hover:bg-white"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              class="h-5 w-5"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
            >
              <path
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"
              />
            </svg>
            <div className="text-lg">Admin</div>
          </a>
        </div>
      </div>
    </nav>
  );
}

export default Navbar;
