import React from "react";

function GetWins(score) {
  if (parseInt(score) > 0) {
    return (
      <div className="inline-flex self-begin gap-1">
        <svg
          width="24"
          height="24"
          viewBox="0 0 24 24"
          fill="none"
          stroke="Gold"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M13 15.9C15.2822 15.4367 17 13.419 17 11V4H7V11C7 13.419 8.71776 15.4367 11 15.9V18H9V20H15V18H13V15.9ZM9 6H15V11C15 12.6569 13.6569 14 12 14C10.3431 14 9 12.6569 9 11V6Z"
            fill="currentColor"
            stroke="Gold"
          />
          <path d="M18 6H20V11H18V6Z" fill="currentColor" />
          <path d="M6 6H4V11H6V6Z" fill="currentColor" />
        </svg>
        {score}
      </div>
    );
  }
}

function PlayerTile(name, score, position) {
  return (
    <div className="grid border-gray-700 w-32 h-32 hover:w-36 hover:h-36 opacity-80 bg-gradient-to-r from-slate-900 text-white p-1  rounded-xl hover:opacity-100">
      <div className="inline-flex self-begin gap-1 text-lg font-bold">
        <svg
          width="24"
          height="24"
          viewBox="0 0 24 24"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M2.5 6.09143L7.21997 10.8114L12.0005 6.03088L16.7811 10.8114L21.5 6.09245V14.9691C21.5 16.626 20.1569 17.9691 18.5 17.9691H5.5C3.84314 17.9691 2.5 16.626 2.5 14.9691V6.09143ZM19.5 10.9087V14.9691C19.5 15.5214 19.0523 15.9691 18.5 15.9691H5.5C4.94771 15.9691 4.5 15.5214 4.5 14.9691V10.9077L7.21997 13.6277L12.0005 8.84717L16.7811 13.6277L19.5 10.9087Z"
            fill="currentColor"
          />
        </svg>
        {position}
      </div>
      <div className="flex-row self-end">
        <div className="grid items-end "> {GetWins(score)} </div>
        <div className="grid items-end ">{name}</div>
      </div>
    </div>
  );
}

export default PlayerTile;
